<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class Cruscotto {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        
        function __construct($db, $id, $nome="", $spazioOccuapto="") {
            $this->db   = $db;
            $this->id   = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccuapto;
        }

        function crea() {
            $query    = "INSERT INTO geec_cruscotti VALUES(NULL,'$this->nome','$this->spazioOccupato')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_cruscotti SET nome='$this->nome', spazioOccupato='$this->spazioOccupato' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_cruscotti",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id componente delle form è 23
            eliminaOccorrenzeComponente($this->db,$this->id,23);
        }
        
        function eliminaMessaggio($idMessaggio) {
            $this->db->eseguiQueryCancellazione("geec_messaggiForm ",$idMessaggio);
        }
        
        function duplica($prefisso = "Copia di") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_cruscotti WHERE id=$this->id");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_cruscotti SELECT * FROM tabella_temporanea;");
            $idNuovaForm = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_cruscotti SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idNuovaForm");
            
            $query       = "SELECT * FROM geec_elementiCruscotto WHERE idCruscotto='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_elementiCruscotto` (`id`, `idCruscotto`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function duplicaElemento($idElemento,$prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_elementiCruscotto WHERE id=$idElemento");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_elementiCruscotto SELECT * FROM tabella_temporanea;");
            $idElementoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_elementiCruscotto SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idElementoDuplicato");
            return $idElementoDuplicato;
        }
        
        function caricaDatiDalDatabase() {
            $datiForm   = $this->db->leggiSingolaRiga("geec_cruscotti",$this->id);
            $this->nome = $datiForm["nome"];
            $this->spazioOccupato        = $datiForm["spazioOccupato"];
        }
        
        function creaElemento($nome,$stile) {
            $queryPosizione = "SELECT * FROM geec_elementiCruscotto WHERE idCruscotto=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geec_elementiCruscotto` (`id`, `idCruscotto`, `posizione`, `spazioOccupato`, `nome`, `coloreSfondo`, `coloreTesti`, `classiAggiuntive`, `icona`, `stile`, `stilePulsanti`, `etichettaPulsante1`, `etichettaPulsante2`, `linkPulsante1`, `linkPulsante2`, `valoreMostrato`, `valoreDaMostrare`, `query`)"
                    . " VALUES (NULL, '$this->id', '$posizione', 'col-12', '$nome', '', '', '', '', '$stile', '', '', '', '', '', 'Valore inserito manualmente', '', '')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function modificaElemento($idElemento, $spazioOccupato, $nome, $coloreSfondo, $coloreTesti,$classiAggiuntive,$icona,$stile,$stilePulsanti,$etichettaPulsante1,$etichettaPulsante2,$linkPulsante1,$linkPulsante2,$valoreMostrato,$valoreDaMostrare,$query) {
            $query = "UPDATE geec_elementiCruscotto SET spazioOccupato='$spazioOccupato', nome='$nome', coloreSfondo='$coloreSfondo', coloreTesti='$coloreTesti', classiAggiuntive='$classiAggiuntive', icona='$icona', stile='$stile', stilePulsanti='$stilePulsanti', etichettaPulsante1='$etichettaPulsante1', etichettaPulsante2='$etichettaPulsante2', linkPulsante1='$linkPulsante1', linkPulsante2='$linkPulsante2', valoreMostrato='$valoreMostrato', valoreDaMostrare='$valoreDaMostrare', query='$query' WHERE id=$idElemento";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_elementiCruscotto WHERE idCruscotto=$this->id AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_elementiCruscotto SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_elementiCruscotto SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_elementiCruscotto",$idElemento);
        }
        
        function stampaElementi() {
                $query = "SELECT * FROM geec_elementiCruscotto WHERE idCruscotto=$this->id ORDER BY posizione ASC";
                $risultatoQuery = $this->db->eseguiQueryLettura($query);
                while($elementoForm = $risultatoQuery->fetch_assoc()) {
                    $nomeEscape = filter_var($elementoForm["nome"],FILTER_SANITIZE_ADD_SLASHES);
            ?>
                    <div id="elementoComponente<?php echo $elementoForm["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center">
                        <div class="mb-1 mb-sm-0 text-muted w-50 text-left">
                            <p class="mb-0"><em><strong><a href="creaElemento.php?id=<?php echo $elementoForm["id"] ?>"><?php echo $elementoForm["nome"] ?></a></strong></em>  </p>
                            <small><em><?php echo $elementoForm["stile"] ?></em>  </small>
                        </div>
                        <div class="azioni d-flex align-items-center justify-content-end">
                            <form class="d-inline-flex mr-sm-1">
                                <div class="input-group input-group-sm d-flex align-items-center">
                                    <small class="text-muted mr-2">Pos.</small>
                                    <input type="number" id="nuovaPosizioneElemento<?php echo $elementoForm["id"] ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $elementoForm["posizione"] ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elementoForm["id"] ?>,<?php echo $elementoForm["posizione"]-1 ?>)">Salva</button>
                                    </div>
                                </div>
                            </form>
                            <div class="btn-group" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="Sposta su" onclick="spostaElemento(<?php echo $elementoForm["id"] ?>,<?php echo $elementoForm["posizione"]-1 ?>)"><i class="fas fa-arrow-up" ></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="Sposta giu" onclick="spostaElemento(<?php echo $elementoForm["id"] ?>,<?php echo $elementoForm["posizione"]+1 ?>)"><i class="fas fa-arrow-down"></i></button>
                                <button type="button" class="btn btn-light modifica" title="Configura elemento" onclick="location.href='creaElemento.php?id=<?php echo $elementoForm["id"] ?>';"><i class="fas fa-cog"></i></button>
                                <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Elimina" onclick="eliminaElemento(<?php echo $elementoForm["id"] ?>,'<?php echo $nomeEscape ?>','<?php echo $elementoForm["tipo"] ?>')" ><i class="far fa-trash-alt"></i></button>
                            </div>
                       </div>
                    </div>
            <?php
                }
        }
        
        // getter & setter
        function getDb() {
            return $this->db;
        }

        function getId() {
            return $this->id;
        }

        function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        function setDb($db) {
            $this->db = $db;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setNome($nome) {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }
        
    }
